#include <stdio.h>
#include <conio.h>
#include <iostream.h>
#pragma hdrstop
#pragma argsused
#include "ltr\\include\\ltrapi_ll.h"
//-----------------------------------------------------------------------------
// /  / 
//-----------------------------------------------------------------------------
INT LTR_Exchange(TLTRUSB *module, DWORD *buf, DWORD size, DWORD timeout, BOOL direction)
{
 OVERLAPPED ov;
 DWORD sz;
 memset(&ov, 0, sizeof(ov));
 ov.hEvent=CreateEvent(NULL, FALSE, TRUE, NULL);
 size*=sizeof(DWORD);
 //    / 
 if(direction==TRUE) WriteFile(module->GetUSBDeviceHandle(), (BYTE*)buf, size, &sz, &ov);
               else  ReadFile(module->GetUSBDeviceHandle(),(BYTE*)buf, size, &sz, &ov);
 //   
 if(WaitForSingleObject(ov.hEvent, timeout)==WAIT_OBJECT_0)
 {
    //    
    GetOverlappedResult(module->GetUSBDeviceHandle(), &ov, &sz, FALSE);
    //   /  
    if(!(sz&3))
    {
        sz/=4;
    } else sz=-2;
 } else sz=-1;
 CancelIo(module->GetUSBDeviceHandle());
 CloseHandle(ov.hEvent);
 return sz;
}
//-----------------------------------------------------------------------------
inline INT LTR_Recv(TLTRUSB *module, DWORD *buf, DWORD size, DWORD timeout)
{
 return LTR_Exchange(module, buf, size, timeout, FALSE);
}
//-----------------------------------------------------------------------------
inline INT LTR_Send(TLTRUSB *module, DWORD *buf, DWORD size, DWORD timeout)
{
 return LTR_Exchange(module, buf, size, timeout, TRUE);
}
//-----------------------------------------------------------------------------
//   
//-----------------------------------------------------------------------------
INT LTR_Filter(DWORD *src_data, DWORD src_data_size, DWORD *dst_data, DWORD filter_mask, DWORD filter_value)
{
 INT dst_data_size=0;
 BOOL signal_flag=FALSE;
 for(int i=0; i<(int)src_data_size; i++) {
    DWORD data=src_data[i];
    //      - -> {0xFFFFFFFF, 0xFFFFAAxx}
    if(data==0xFFFFFFFF) signal_flag=TRUE;
    else {
        if(signal_flag==TRUE && (data>>8)==0xFFFFAA){
            //   -
        } else {
            //    
            if((data&filter_mask)==filter_value) {
                dst_data[dst_data_size++]=data;
            }
        }
        signal_flag=FALSE;
    }
 }
 return dst_data_size;
}
//-----------------------------------------------------------------------------
int main(int argc, char* argv[])
{
 TLTRUSB *module= CreateInstanceUSB();
 if(module!=NULL)
 {
    int i=0;
    for (i = 0; i <= 100; i++)
    {

        if(module->GetUSBDeviceHandle())
        {
        module->SwitchBootloader(false);
        printf(">> OpenLDevice() -> ok\n");
        if(module->Application->LoadFPGAFromFile("ltr.ttf", 7, 0))
        {
            printf(">> LoadFPGAFromFile() -> ok\n");
            //   
            TDESCRIPTION_LTR010 description;
            if(module->Application->GetModuleDescription(&description))
            {
                printf(">> Module description : \n");
                printf(">> + CompanyName  = %s\n", description.Module.CompanyName);
                printf(">> + DeviceName   = %s\n", description.Module.DeviceName);
                printf(">> + SerialNumber = %s\n", description.Module.SerialNumber);
                if(description.Cpu.Active)
                {
                    printf(">> Cpu description :\n");
                    printf(">> + Name      = %s\n", description.Cpu.Name);
                    printf(">> + ClockRate = %.1f MHz\n", description.Cpu.ClockRate/(1e6));
                    DWORD fwv=description.Cpu.FirmwareVersion;
                    printf(">> + FirmWare  = %d.%d.%d.%d\n", (fwv>>24)&255, (fwv>>16)&255, (fwv>>8)&255, (fwv>>0)&255);
                    printf(">> + Conmmet   = %s\n", description.Cpu.Comment);
                } else printf(">> Cpu description not accessible\n");
                if(description.Fpga.Active)
                {
                    printf(">> Fpga description :\n");
                    printf(">> + Name      = %s\n", description.Fpga.Name);
                    DWORD fwv=description.Fpga.FirmwareVersion;
                    printf(">> + FirmWare  = %d.%d.%d.%d\n", (fwv>>24)&255, (fwv>>16)&255, (fwv>>8)&255, (fwv>>0)&255);
                    printf(">> + Conmmet   = %s\n", description.Fpga.Comment);
                } else printf(">> Fpga description not accessible\n");
                if(description.Interface.Active)
                {
                    printf(">> Interface description :\n");
                    printf(">> + Name      = %s\n", description.Interface.Name);
                    printf(">> + Comment   = %s\n", description.Interface.Comment);
                } else printf("## Interface description not accessible\n");
            } else printf(">> GetModuleDescription() -> error\n");

            {
                DWORD data[16*1024];
                for(int i=0; i<MODULE_MAX; i++) data[i]=LTR010CMD_STOP|(i<<8);
                //  LTR_Send(module, data, MODULE_MAX, 2000);
                //
                DWORD tbegin = GetTickCount();
                while((GetTickCount()-tbegin)<5000)
                {
                    int sz= LTR_Recv(module, data, 16*1024, 3000);
                    printf(">> sz=%d\n", sz);
                }
            }


            //      
            DWORD src_data[3*MODULE_MAX];
            for(int i=0; i<MODULE_MAX; i++)
            {
                src_data[3*i+0]=LTR010CMD_STOP |(i<<8);
                src_data[3*i+1]=LTR010CMD_STOP |(i<<8);
                src_data[3*i+2]=LTR010CMD_RESET|(i<<8);
            }
            //
            if(LTR_Send(module, src_data, 3*MODULE_MAX, 2000)==(3*MODULE_MAX))
            {
                INT src_data_size=LTR_Recv(module, src_data, 3*MODULE_MAX, 2000);
                if(src_data_size>=0)
                {
                    printf(">> LTR_Recv() -> ok (%d)\n", src_data_size);
                    printf(">> Crate module info :\n");
                    for(int i=0; i<MODULE_MAX; i++)
                    {
                        DWORD dst_data[3*MODULE_MAX];
                        //    
                        INT dst_data_size=LTR_Filter(src_data, src_data_size, dst_data, LTR010CMD_RESET|LTR010_SLOT_MASK, LTR010CMD_RESET|(i<<8));
                        if(dst_data_size)
                        {
                            printf(">> Slot%02d : LTR%d\n", i+1, (dst_data[0]>>16)&0xFF);
                        } else printf(">> Slot%02d : empty\n", i+1);
                    }
                } else printf(">> LTR_Recv() -> error\n");
            } else printf(">> LTR_Send() -> error\n");
        } else printf(">> LoadFPGAFromFile() -> error\n");
        //
        module->CloseLDevice();
        break;
    };
 }
 if (i>=100) printf(">> OpenLDevice() -> error\n");
    //
 } else printf(">> CreateInstance() -> error\n");
 if(module!=NULL) DeleteInstanceUSB(module) ;
 //
 printf("press any key...\n");
 while(!kbhit());
 getch();
 return 0;
}
//-----------------------------------------------------------------------------
